#include <OutlookEX.au3>
#include <OutlookEX_GUI.au3>
#include <MsgBoxConstants.au3>

Global $oOL = _OL_Open()
If @error <> 0 Then Exit MsgBox($MB_ICONERROR, "_OL_SelectionSet Example Script", "Error creating a connection to Outlook. @error = " & @error & ", @extended = " & @extended)

; *****************************************************************************
; Example 1
; Select items 1, 2 and 3 of the active view
; *****************************************************************************
_OL_SelectionSet($oOL, $oOL.ActiveExplorer.CurrentFolder.Items(1))
If @error <> 0 Then Exit MsgBox($MB_ICONERROR, "_OL_SelectionSet Example Script", "Error setting a selection. @error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "_OL_SelectionSet", "Item 1 selected!")

_OL_SelectionSet($oOL, $oOL.ActiveExplorer.CurrentFolder.Items(2))
If @error <> 0 Then Exit MsgBox($MB_ICONERROR, "_OL_SelectionSet Example Script", "Error setting a selection. @error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "_OL_SelectionSet", "Item 2 selected!")

_OL_SelectionSet($oOL, $oOL.ActiveExplorer.CurrentFolder.Items(3))
If @error <> 0 Then Exit MsgBox($MB_ICONERROR, "_OL_SelectionSet Example Script", "Error setting a selection. @error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "_OL_SelectionSet", "Item 3 selected!")

; ***************************************************************************************
; Example 2
; Remove selection of item 2
; ***************************************************************************************
_OL_SelectionSet($oOL, $oOL.ActiveExplorer.CurrentFolder.Items(2), 2)
If @error <> 0 Then Exit MsgBox($MB_ICONERROR, "_OL_SelectionSet Example Script", "Error unselecting an item. @error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "_OL_SelectionSet", "Item 2 unselected!")

; ***************************************************************************************
; Example 3
; Remove all remaining selected items
; ***************************************************************************************
_OL_SelectionSet($oOL, -1, 2)
If @error <> 0 Then Exit MsgBox($MB_ICONERROR, "_OL_SelectionSet Example Script", "Error unselecting all selected items. @error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "_OL_SelectionSet", "All remaining selected items have been unselected!")

; ***************************************************************************************
; Example 4
; Select all items
; ***************************************************************************************
_OL_SelectionSet($oOL, -1)
If @error <> 0 Then Exit MsgBox($MB_ICONERROR, "_OL_SelectionSet Example Script", "Error selecting all items. @error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "_OL_SelectionSet", "All items selected!")

; ***************************************************************************************
; Example 5
; Remove all selected items
; ***************************************************************************************
_OL_SelectionSet($oOL, -1, 2)
If @error <> 0 Then Exit MsgBox($MB_ICONERROR, "_OL_SelectionSet Example Script", "Error unselecting all items. @error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "_OL_SelectionSet", "All items unselected!")

; ***************************************************************************************
; Example 6
; Select all unread mails in the current folder
; ***************************************************************************************
$aItems = _OL_ItemFind($oOL, $oOL.ActiveExplorer.CurrentFolder, $olMail, "[UnRead]=True", "", "", "Subject,Body,EntryID", "", 1)
If @error = 0 Then
	_ArrayDisplay($aItems, "_OL_SelectionSet Example Script - Unread mails")
Else
	MsgBox($MB_ICONWARNING, "_OL_SelectionSet Example Script", "Could not find an unread mail. @error = " & @error & ", @extended: " & @extended)
EndIf
_OL_SelectionSet($oOL, $aItems, 1, Default, 1, 2)
If @error <> 0 Then Exit MsgBox($MB_ICONERROR, "_OL_SelectionSet Example Script", "Error selecting specified items. @error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "_OL_SelectionSet", "All unread mails selected!")

_OL_Close($oOL)