#include <OutlookEX.au3>
#include <OutlookEX_GUI.au3>


; OlActionCopyLike enumeration. Specifies how item properties will be copied
Global Const $olForward = 2 ; Properties of the new item will be set such that the new item is a forward of the original item. If creating a new MailItem, the value of the To and CC properties in the new item will be empty and the Subject property of the new item will be the original Subject with a prefix such as "FW:" (see Prefix property) added. The attachments on the original item will be copied to the new item.
Global Const $olReply = 0 ; Properties of the new item will be set such that the new item is a reply to the original item. If creating a new MailItem, the value of the original To field will be copied to the SenderEmailAddress property of the new item, the CC field will be blank and the Subject field of the new item will be the original Subject with a prefix such as "RE:" (see Prefix property) added.
Global Const $olReplyAll = 1 ; Properties of the new item will be set such that the new item is a reply to all of the senders of the original item. If creating a new MailItem, the value of the SenderEmailAddress and CC properties will be copied to the To property of the new item and the Subject property of the new item will be the Subject of the original item with a prefix such as "RE:" (see Prefix property) added.
Global Const $olReplyFolder = 3 ; If creating a new PostItem based on an old one, the Post To property of the new item will contain the active folder address, the Subject property of the original item will be copied to the ConversationTopic property of the new item, and the Subject property of the new item will be empty.
Global Const $olRespond = 4 ; Used exclusively for voting button actions.

; OlActionReplyStyle enumeration. Specifies the reply style
Global Const $olEmbedOriginalItem = 1 ; The reply will include the original item embedded in it.
Global Const $olIncludeOriginalText = 2 ; The reply will include the text of the original item.
Global Const $olIndentOriginalText = 3 ; The reply will include the indented text of the original item.
Global Const $olLinkOriginalItem = 4 ; The reply will include a link to the original item.
Global Const $olOmitOriginalText = 0 ; The reply will not include any references to the original item or its text.
Global Const $olReplyTickOriginalText = 1000 ; The reply will include the original text with each line preceded by a symbol such as ">".
Global Const $olUserPreference = 5 ; The reply style will be set based on the user's preference.

; OlActionResponseStyle enumeration. Specifies the response style
Global Const $olOpen = 0 ; Indicates that a form will be opened.
Global Const $olPrompt = 2 ; Indicates that the user will be prompted to open or send the form.
Global Const $olSend = 1 ; Indicates that the form will be sent immediately.

; OlActionShowOn enumeration. Identifies where an Action is displayed as an available action
Global Const $olDontShow = 0 ; Indicates that the action will not be displayed on the menu or toolbar.
Global Const $olMenu = 1 ; Indicates that the action will be displayed as an available action on the menu.
Global Const $olMenuAndToolbar = 2 ; Indicates that the action will be displayed as an available action on the menu and the toolbar.

; *****************************************************************************
; Create test environment
; *****************************************************************************
Global $oItem
Global $oOutlook = _OL_Open()
If @error <> 0 Then Exit MsgBox(16, "OutlookEX UDF", "Error creating a connection to Outlook. @error = " & @error & ", @extended = " & @extended)
Global $Result = _OL_TestEnvironmentCreate($oOutlook)
If @error <> 0 Then Exit MsgBox(16, "OutlookEX UDF - Manage Test Environment", "Error creating the test environment. @error = " & @error & ", @extended = " & @extended)

; *****************************************************************************
; Example 1
; Create a mail with predefined actions (but don't send it)
; *****************************************************************************
$oItem = _OL_ItemCreate($oOutlook, $olMailItem, "*\Outlook-UDF-Test\TargetFolder\Mail", "", "Subject=TestMail", "Body=Testmail with action!")
If @error <> 0 Then Exit MsgBox(16, "OutlookEX UDF: _OL_ItemActionAdd Example Script", "Error creating a mail in folder 'Outlook-UDF-Test\TargetFolder\Mail'. @error = " & @error & ", @extended = " & @extended)

Global $sName = "Test"
Global $sPrefix = "Test-RE"
Global $iCopyLike = Default
Global $iShowOn = $olMenuAndToolbar
Global $iReplyStyle = Default
Global $iResponseStyle = Default
_OL_ItemActionAdd($oItem, $sName, $sPrefix, $iCopyLike, $iShowOn, $iReplyStyle, $iResponseStyle)
If @error Then Exit MsgBox(16, "OutlookEX UDF: _OL_ItemActionAdd Example Script", "Error setting the action. @error = " & @error & ", @extended = " & @extended)
$oItem.Display
MsgBox(64, "OutlookEX UDF: _OL_ItemActionAdd Example Script", "Mail with voting buttons created.")

_OL_Close($oOutlook)

; #FUNCTION# ====================================================================================================================
; Name ..........: _OL_ItemActionAdd
; Description ...: Adds a specialized action (for example, the voting options response) that can be executed on an Outlook item.
; Syntax.........: _OL_ItemActionAdd($oItem, $sName[, $sPrefix = ""[, $iCopyLike = $olReply[, $iShowOn = $olDontShow[, $iReplyStyle = $olReplyTickOriginalText[, $iResponseStyle = $olOpen]]]]])
; Parameters ....: $oItem          -
;                  $sName          - Display name for the object
;                  $sPrefix        - [optional] Specifies the prefix (for example, "Re") to use with the subject of the item when the action is executed (default = "")
;                  $iCopyLike      - [optional] Specifies how item properties will be copied. Has to be a value of the OlActionCopyLike enumeration (default = OlReply)
;                  $iShowOn        - [optional] Location where the action will be shown. Has to be a value of the OlActionShowOn enumeration (default = OlActionShowOn)
;                  $iReplyStyle    - [optional] Text formatting reply style for the specified action. Has to be a value of the OlActionReplyStyle enumeration (default = olReplyTickOriginalText)
;                  $iResponseStyle - [optional] Response style used when the specified action is executed. Has to be a value of the OlActionResponseStyle enumeration (default = olOpen)
; Return values .: Success - The object of the created action
;                  Failure - Returns 0 and sets @error:
;                  |1 - Error adding the action to the item. @error is set to the COM error code
; Author ........: water
; Modified ......:
; Remarks .......:
; Related .......:
; Link ..........:
; Example .......: Yes
; ===============================================================================================================================
Func _OL_ItemActionAdd($oItem, $sName, $sPrefix = Default, $iCopyLike = Default, $iShowOn = Default, $iReplyStyle = Default, $iResponseStyle = Default)
	If $sPrefix = Default Then $sPrefix = ""
	If $iCopyLike = Default Then $iCopyLike = $OlReply
	If $iShowOn = Default Then $iShowOn = $olDontShow
	If $iReplyStyle = Default Then $iReplyStyle = $olReplyTickOriginalText
	If $iResponseStyle = Default Then $iResponseStyle = $olOpen
	$oAction = $oItem.Actions.Add()
	If @error Then Return Seterror(1, @error, 0)
	$oAction.Name = $sName
	$oAction.Enabled = True
	$oAction.Prefix = $sPrefix
	$oAction.CopyLike = $iCopyLike
	$oAction.ShowOn = $iShowOn
	$oAction.ReplyStyle = $iReplyStyle
	$oAction.ResponseStyle = $iResponseStyle
	Return $oAction
EndFunc