#include <OutlookEX_GUI.au3>
#include <MsgBoxConstants.au3>

Global $sView = "Test OutlookEXGUI"
Global $oOutlook = _OL_Open()
If @error <> 0 Then Exit MsgBox($MB_ICONERROR, "_OL_ViewApply Example Script", "Error creating a connection to Outlook. @error = " & @error & ", @extended = " & @extended)

; *****************************************************************************
; Example 1
; Apply view "Test OutlookEXGUI" to the inbox
; *****************************************************************************
; Access the inbox
Global $aFolder = _OL_FolderAccess($oOutlook, "", $olFolderInbox)
If @error <> 0 Then Exit MsgBox($MB_ICONERROR, "_OL_ViewApply Example Script", "Error accessing the inbox folder. @error = " & @error & ", @extended = " & @extended)
; Make sure the view exists
If _OL_ViewExists($oOutlook, $sView, $aFolder[1]) = False Then Exit MsgBox($MB_ICONERROR, "_OL_ViewApply Example Script", "View '" & $sView & "' does not exist for the inbox." & _
		@CRLF & "Please run _OL_ViewCreate to create this view.")
; Apply the view
Global $oView = _OL_ViewApply($oOutlook, $sView, $aFolder[1])
If @error <> 0 Then Exit MsgBox($MB_ICONERROR, "_OL_ViewApply Example Script", "Error applying the view to the inbox folder. @error = " & @error & ", @extended = " & @extended)
MsgBox($MB_ICONINFORMATION, "_OL_ViewApply Example Script", "View '" & $sView & "' has been applied to the inbox folder")

_OL_Close($oOutlook)
