#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=N
#include <Array.au3>
#include <PowerPoint.au3>
#include <MsgBoxConstants.au3>

; **********************************************************
; Create application object and open an example presentation
; **********************************************************
Global $sPresentation = @ScriptDir & "\Presentation1.pptx"
Global $oPPT = _PPT_Open()
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_SlideRangeCreate Example", "Error creating the PowerPoint application object." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
Global $oPresentation = _PPT_PresentationOpen($oPPT, $sPresentation)
If @error Then
	MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_SlideRangeCreate Example", "Error opening presentation '" & $sPresentation & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
	_PPT_Close($oPPT)
	Exit
EndIf

; *****************************************************************************
; Create a Slide Range
; *****************************************************************************
Global $oSlideRange, $sSlideRange
Global $aSlides[] = [1,2]

$oSlideRange = _PPT_SlideRangeSet($oPresentation, "1-2")                             ; First and last Slide of the SlideRange
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_SlideRangeCreate Example 1", "Error creating a SlideRange for '" & $sPresentation & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
For $i = 1 to $oSlideRange.Count
	if $i = 1 Then
		$sSlideRange = $oSlideRange.Item($i).SlideIndex
	Else
		$sSlideRange = $sSlideRange & "," & @CRLF & $oSlideRange.Item($i).SlideIndex
		endif
Next
MsgBox($MB_ICONINFORMATION, "PowerPoint UDF: _PPT_SlideRangeCreate Example 1", "Slide Range created including the following slides:" & @CRLF & $sSlideRange)

; More Examples
; $oSlideRange = _PPT_SlideRangeSet($oPresentation, $oPresentation.Slides(1))        ; Slide object
; $oSlideRange = _PPT_SlideRangeSet($oPresentation, $oPresentation.Slides.Range(1))  ; SlideRange object
; $oSlideRange = _PPT_SlideRangeSet($oPresentation, 1)                               ; SlideIndex
; $oSlideRange = _PPT_SlideRangeSet($oPresentation, $aSlides)                        ; List of Slides passed in an array
; $oSlideRange = _PPT_SlideRangeSet($oPresentation, "2-*")                           ; First and last Slide of the SlideRange