#AutoIt3Wrapper_AU3Check_Parameters= -d -w 1 -w 2 -w 3 -w 4 -w 5 -w 6
#AutoIt3Wrapper_AU3Check_Stop_OnWarning=N
#include <PowerPoint.au3>
#include <MsgBoxConstants.au3>
#include <Array.au3>

; **********************************************************
; Create application object and open an example presentation
; **********************************************************
Global $oPPT = _PPT_Open()
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_CommentList Example", "Error creating the PowerPoint application object." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
Global $sPresentation = @ScriptDir & "\Presentation1.pptx"
Global $oPresentation = _PPT_PresentationOpen($oPPT, $sPresentation)
If @error Then
	MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_CommentList Example", "Error opening presentation '" & $sPresentation & "'." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
	_PPT_Close($oPPT)
	Exit
EndIf

; *****************************************************
; Example 1
; Create every possible comment near Shape 2 on Slide 2
; *****************************************************
_PPT_CommentAdd($oPresentation, 2, 2, 1, 1, "Shape Comment Left/Top", "Jon Doe", @UserName, "AD", @UserName)
If @error Then Exit MsgBox($MB_ICONERROR, "PowerPoint UDF: _PPT_CommentList Example 1", "Error adding comment." & @CRLF & "@error = " & @error & ", @extended = " & @extended)
_PPT_CommentAdd($oPresentation, 2, 2, 1, 2, "Shape Comment Left/Middle", "Jon Doe", @UserName, "AD", @UserName)
_PPT_CommentAdd($oPresentation, 2, 2, 1, 3, "Shape Comment Left/Bottom", "Jon Doe", @UserName, "AD", @UserName)

_PPT_CommentAdd($oPresentation, 2, 2, 2, 1, "Shape Comment Right/Top", "Jon Doe", @UserName, "AD", @UserName)
_PPT_CommentAdd($oPresentation, 2, 2, 2, 2, "Shape Comment Right/Middle", "Jon Doe", @UserName, "AD", @UserName)
_PPT_CommentAdd($oPresentation, 2, 2, 2, 3, "Shape Comment Right/Bottom", "Jon Doe", @UserName, "AD", @UserName)

_PPT_CommentAdd($oPresentation, 2, 2, 3, 1, "Shape Comment Top/Left", "Jon Doe", @UserName, "AD", @UserName)
_PPT_CommentAdd($oPresentation, 2, 2, 3, 2, "Shape Comment Top/Middle", "Jon Doe", @UserName, "AD", @UserName)
_PPT_CommentAdd($oPresentation, 2, 2, 3, 3, "Shape Comment Top/Right", "Jon Doe", @UserName, "AD", @UserName)

_PPT_CommentAdd($oPresentation, 2, 2, 4, 1, "Shape Comment Bottom/Left", "Jon Doe", @UserName, "AD", @UserName)
_PPT_CommentAdd($oPresentation, 2, 2, 4, 2, "Shape Comment Bottom/Middle", "Jon Doe", @UserName, "AD", @UserName)
_PPT_CommentAdd($oPresentation, 2, 2, 4, 3, "Shape Comment Bottom/Right", "Jon Doe", @UserName, "AD", @UserName)
$oPresentation.Slides(2).Select

Global $aComments = _PPT_CommentList($oPresentation)
_ArrayDisplay($aComments)

Exit
